<%@ Page language="c#" Codebehind="WF_Tips.aspx.cs" AutoEventWireup="false" Inherits="ActiveDataOnline.WebForum.WF_Tips" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<!-- Note:	Be careful not to remove or alter ASP.NET or server-side tags, otherwise the application might not work properly. -->
<!--				But, feel free to add HTML to the page and/or change style sheet settings, and the like. -->
<html>
	<head>
		<meta name="AUTHOR" content="Active Data Online Pty Ltd">
		<meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
		<meta name="CODE_LANGUAGE" Content="C#">
		<meta name="vs_defaultClientScript" content="JavaScript (ECMAScript)">
		<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
		<title runat="server" id="PageTitle" />
		<link rel="stylesheet" href="WF_Styles.css" type="text/css">
	</head>
	<body MS_POSITIONING="GridLayout">
		<h1 id="H1PageTitle" runat="server" />
		<br>
		<h2>
			WebForum Markup Language
		</h2>
		<form id="Tips" method="post" runat="server">
			<p>
				Make the most out of WebForum by using its special markup language:
			</p>
			<ul>
				<li>
					<a href="#format">format tags</a></li>
				<li>
					<a href="#structure">structure tags</a></li>
				<li>
					<a href="#icons">icon tag</a></li>
			</ul>
			<br>
			<p>
				<b><a name="format">1.</a></b> Format parts of your messages with WebForum's 
				format tags. To format one or more words, enclose the target text within a set 
				of format tags.
			</p>
			<br>
			<p style="color:darkblue">
				&lt;wf:bold&gt;&lt;/wf:bold&gt;
			</p>
			<p>
				Creates bold text. eg, &lt;wf:bold&gt;abc&lt;/wf:bold&gt; produces <b>abc</b>
			</p>
			<br>
			<p style="color:darkblue">
				&lt;wf:italic&gt;&lt;/wf:italic&gt;
			</p>
			<p>
				Creates italic text. eg, &lt;wf:italic&gt;abc&lt;/wf:italic&gt; produces <i>abc</i>
			</p>
			<br>
			<p style="color:darkblue">
				&lt;wf:underline&gt;&lt;/wf:underline&gt;
			</p>
			<p>
				Creates underlined text. eg, &lt;wf:underline&gt;abc&lt;/wf:underline&gt; 
				produces <u>abc</u>
			</p>
			<br>
			<p style="color:darkblue">
				&lt;wf:strike&gt;&lt;/wf:strike&gt;
			</p>
			<p>
				Creates striked text. eg, &lt;wf:strike&gt;abc&lt;/wf:strike&gt; produces <strike>abc</strike>
			</p>
			<br>
			<p>
				<b><a name="structure">2.</a></b> Structure parts of your messages with 
				WebForum's structure tags. To structure a list or a paragraph, enclose it 
				within the appropriate structure tags.
			</p>
			<br>
			<p style="color:darkblue">
				&lt;wf:list&gt;&lt;wf:listitem&gt;&lt;/wf:listitem&gt;&lt;/wf:list&gt;
			</p>
			<p>
				Creates a bulleted list.
				<br>
				eg, 
				&lt;wf:list&gt;&lt;wf:listitem&gt;One&lt;/wf:listitem&gt;&lt;wf:listitem&gt;Two&lt;/wf:listitem&gt;&lt;/wf:list&gt; 
				produces
			</p>
			<ul>
				<li>
					One</li>
				<li>
					Two</li>
			</ul>
			<br>
			<p style="color:darkblue">
				&lt;wf:blockquote&gt;&lt;/wf:blockquote&gt;
			</p>
			<p>
				Creates an indented paragraph, useful for quoting or highlighting text.
				<br>
				eg, &lt;wf:blockquote&gt;One. Two. Three. Four. Five. Six. Seven. Eight. Nine. 
				Ten. Eleven. Twelve. Thirteen. Fourteen. Fifteen. Sixteen. Seventeen. Eighteen. 
				Nineteen. Twenty.&lt;/wf:blockquote&gt; produces
				<br>
				<blockquote>
					<p>
						One. Two. Three. Four. Five. Six. Seven. Eight. Nine. Ten. Eleven. Twelve. 
						Thirteen. Fourteen. Fifteen. Sixteen. Seventeen. Eighteen. Nineteen. Twenty.
					</p>
				</blockquote>
			</p>
			<br>
			<p>
				<b><a name="icons">3.</a></b> Include icons in your messages with WebForum's 
				icon tags. Icon graphics are made available by the administrator of a WebForum 
				and are managed within the administrative area of WebForum. The icon management 
				system permits a WebForum to offer a unique and unlimited set of icons for its 
				members to use.
			</p>
			<br>
			<p style="color:darkblue">
				&lt;wf:icon id="[Number]"/&gt;
			</p>
			<p>
				Creates an icon graphic. If an icon graphic exists for the specified icon id, 
				WebForum will transform the tag into an image. When using icons, ensure that 
				the syntax of icon tags are written properly; otherwise the desired image won't 
				be rendered.
			</p>
			<p>
				<asp:label id="IconsLabel" width="100%" runat="server" />
			</p>
			<asp:DataGrid id="IconsGrid" autogeneratecolumns="False" borderwidth="1" bordercolor="black" width="100%" cellpadding="5" cellspacing="0" CssClass="DataGrid" alternatingitemstyle-backcolor="#dddddd" allowpaging="True" pagerstyle-mode="NumericPages" onpageindexchanged="IconsPage" pagesize="20" AllowSorting="True" OnSortCommand="IconsSort" Runat="server">
				<Columns>
					<asp:boundcolumn itemstyle-width="10%" headerstyle-font-bold="False" headerstyle-forecolor="White" headerstyle-backcolor="Darkblue" headertext="ID" datafield="fldIconID" SortExpression="fldIconID" />
					<asp:boundcolumn itemstyle-width="30%" headerstyle-font-bold="False" headerstyle-forecolor="White" headerstyle-backcolor="Darkblue" headertext="Image" datafield="formattedIconImage" />
					<asp:boundcolumn itemstyle-width="30%" headerstyle-font-bold="False" headerstyle-forecolor="White" headerstyle-backcolor="Darkblue" headertext="Description" datafield="fldIconDescription" SortExpression="fldIconDescription" />
					<asp:boundcolumn itemstyle-width="30%" headerstyle-font-bold="False" headerstyle-forecolor="White" headerstyle-backcolor="Darkblue" headertext="Syntax" datafield="formattedIconSyntax" />
				</Columns>
			</asp:DataGrid>
			<br>
		</form>
		<br>
		<div class="small" id="ActiveDataOnline_Copyright" runat="server" />
	</body>
</html>
